#ifndef LISTECHAINEE_H
#define LISTECHAINEE_H

#include <stdio.h>
#include <string.h>

template <class T>
struct Cellule
{
    Cellule<T> * m_pSuivant ;
    Cellule<T> * m_pPrecedent ;
    char * m_szNom ;
    T * m_pValeur ;
};

template <class T>
class ListeChainee
{
    private:
        Cellule<T> * m_pDebut;
        Cellule<T> * m_pCourant;
        Cellule<T> * m_pFin;
        int m_iSize;
        int m_iRang;
        
        Cellule<T> * getCellule( const char * szNom ) ;
        Cellule<T> * getCellule( const int iRang ) ;
    public:
        ListeChainee();
        ~ListeChainee();
        // Ajoute une nouvelle cellule  la fin de la liste
        inline void add( T * pValeur, char * szNom );
        // vide la liste chainee
        void vider();
        // Supprime la derniere cellule      
        inline void del();
        inline void del( char * szNom );
        inline void del( const int iRang );
        inline void modify (T * valeur, char * szNom);
        inline T * get ( const char * szNom ) ;
        inline T * get ( const int iRang );
        // retourne le nom de la cellule courante
        char * getNom () { return m_pCourant->m_szNom; }
        inline T * getCourant() ;
        void debut() { m_pCourant=m_pDebut; m_iRang=0 ; }
        void fin() { m_pCourant=m_pFin; m_iRang=m_iSize-1 ; }
        inline bool suivant();
        inline bool precedent();
        inline void initialiser();
        int getSize() { return m_iSize ; }
        void delCourant();
        int getRang() { return m_iRang ; }
        int getRang(char *szNom) ;
};

template <class T>
T * ListeChainee<T>::getCourant()
{
    if (m_pCourant != NULL)
        return m_pCourant->m_pValeur;
    else
        return NULL;
        
}

template <class T>
ListeChainee<T>::ListeChainee()
{
    printf("  Dans Constructeur ListeChainee\n");
    initialiser();
}

template <class T>
ListeChainee<T>::~ListeChainee()
{
    printf("  Dans Destructeur ListeChainee\n");

    while ( m_pFin != NULL )
    {   
        del();
    }
}

// ajoute  la fin de la liste la cellule de nom sznom
// attention le nom de la cellule ne doit pas dj exiter dans la liste
template <class T>
void ListeChainee<T>::add(T *pValeur,char *szNom)
{
    if ( m_iSize == 0 )
    {
        m_pDebut = new Cellule<T>;
        m_pDebut->m_pSuivant=NULL;
        m_pDebut->m_pPrecedent=NULL;
        m_pDebut->m_pValeur=pValeur;
        m_pDebut->m_szNom=szNom;    
        m_pFin=m_pDebut;
        debut();
    }
    else
    {
        m_pFin->m_pSuivant=new Cellule<T>; 
        m_pFin->m_pSuivant->m_pSuivant=NULL;
        m_pFin->m_pSuivant->m_pPrecedent=m_pFin;
        m_pFin->m_pSuivant->m_pValeur=pValeur;
        m_pFin->m_pSuivant->m_szNom=szNom;
        
        m_pFin=m_pFin->m_pSuivant;
    }
    
    m_iSize++;
}

// supprime la derniere cellule
template <class T>
void ListeChainee<T>::del()
{
    if ( m_iSize > 0 )
    {
        if ( m_iSize == 1 )
        {
              delete m_pFin->m_pValeur;
              delete m_pFin;  
              initialiser();           
        }
        else
        {
                if ( m_pCourant == m_pFin )
                {
                      precedent();
                }                
                m_pFin=m_pFin->m_pPrecedent;
                delete m_pFin->m_pSuivant->m_pValeur;
                delete m_pFin->m_pSuivant;
                m_pFin->m_pSuivant=NULL;
                m_iSize--;
        }
        
    }
}

template <class T>
void ListeChainee<T>::del( char * szNom )
{
    Cellule<T> *pTemp = getCellule ( szNom );
    
    if ( pTemp != NULL )
    {
        if (m_pCourant == pTemp)
        {
            if (m_pCourant->m_pPrecedent == NULL)
                 suivant();
            else
                 precedent();
        }
        if ( m_iSize == 1 )
        {  
                
                delete (pTemp->m_pValeur);
                delete (pTemp);
                initialiser();
        }
        else
        {
             if (pTemp == m_pDebut)
             {
                 pTemp->m_pSuivant->m_pPrecedent = NULL;
                 m_pDebut = pTemp->m_pSuivant;
             }
             else if (pTemp == m_pFin)
             {
                 pTemp->m_pPrecedent->m_pSuivant = NULL;
                 m_pFin = pTemp->m_pPrecedent;
             }
             else
             {
                 pTemp->m_pPrecedent->m_pSuivant = pTemp->m_pSuivant;
                 pTemp->m_pSuivant->m_pPrecedent = pTemp->m_pPrecedent;
             }
             delete (pTemp->m_pValeur);
             delete (pTemp);
             m_iSize--;              
        }
    }
}

template <class T>
void ListeChainee<T>::del( const int iRang )
{
    Cellule<T> *pTemp = getCellule ( iRang );
    
    if ( pTemp != NULL )
    {
        if (m_pCourant == pTemp)
        {
            if (m_pCourant->m_pPrecedent == NULL)
                 suivant();
            else
                 precedent();
        }
        if ( m_iSize == 1 )
        {  
                
                delete (pTemp->m_pValeur);
                delete (pTemp);
                initialiser();
        }
        else
        {
             if (pTemp == m_pDebut)
             {
                 pTemp->m_pSuivant->m_pPrecedent = NULL;
                 m_pDebut = pTemp->m_pSuivant;
             }
             else if (pTemp == m_pFin)
             {
                 pTemp->m_pPrecedent->m_pSuivant = NULL;
                 m_pFin = pTemp->m_pPrecedent;
             }
             else
             {
                 pTemp->m_pPrecedent->m_pSuivant = pTemp->m_pSuivant;
                 pTemp->m_pSuivant->m_pPrecedent = pTemp->m_pPrecedent;
             }
             delete (pTemp->m_pValeur);
             delete (pTemp);
             m_iSize--;              
        }
    }
}

template <class T>
void ListeChainee<T>::delCourant()
{
    Cellule<T> *pTemp = m_pCourant;
    
    if ( pTemp != NULL )
    {
        if (m_pCourant == pTemp)
        {
            if (m_pCourant->m_pPrecedent == NULL)
                 suivant();
            else
                 precedent();
        }
        if ( m_iSize == 1 )
        {  
                
                delete (pTemp->m_pValeur);
                delete (pTemp);
                initialiser();
        }
        else
        {
             if (pTemp == m_pDebut)
             {
                 pTemp->m_pSuivant->m_pPrecedent = NULL;
                 m_pDebut = pTemp->m_pSuivant;
             }
             else if (pTemp == m_pFin)
             {
                 pTemp->m_pPrecedent->m_pSuivant = NULL;
                 m_pFin = pTemp->m_pPrecedent;
             }
             else
             {
                 pTemp->m_pPrecedent->m_pSuivant = pTemp->m_pSuivant;
                 pTemp->m_pSuivant->m_pPrecedent = pTemp->m_pPrecedent;
             }
             delete (pTemp->m_pValeur);
             delete (pTemp);
             m_iSize--;              
        }
    }
}

template <class T>
void ListeChainee<T>::modify(T * pValeur, char * szNom)
{
    Cellule<T> * pTemp;
    pTemp = getCellule(szNom);
    
      if ( pTemp != NULL)
      {
            pTemp->m_pValeur=pValeur;
      }
}

template <class T>
T * ListeChainee<T>::get ( const char * szNom )
{
    Cellule<T> * pTemp;
    pTemp = getCellule(szNom);
    
    if ( pTemp != NULL)
    {
        return pTemp->m_pValeur;
    }
    return NULL;
}

template <class T>
T * ListeChainee<T>::get ( const int iRang )
{
    Cellule<T> * pTemp;
    pTemp = getCellule(iRang);
    
    if ( pTemp != NULL )
    {
        return pTemp->m_pValeur;
    }
    return NULL;
}


// dplace de pointeur courant  la cllule prcedente
// retourne false si le pointeur courant est dj au dbut
template <class T>
bool ListeChainee<T>::precedent()
{
    if ( m_pCourant != m_pDebut && m_iSize > 0 )
    {
        m_pCourant = m_pCourant->m_pPrecedent;
        m_iRang--;
        return true;
    }
    else
    {
        return false;
    }
}

// dplace de pointeur courant  la cellule suivant
// retourne false si le pointeur courant est dj  la fin
template <class T>
bool ListeChainee<T>::suivant()
{
    if ( m_pCourant != m_pFin && m_iSize > 0 )
    {
        m_pCourant = m_pCourant->m_pSuivant;
        m_iRang++;
        return true;
    }
    else
    {
        return false;
    }
}



// cherche une cellule dans la liste par rapport  son nom
// retourne NULL si cellule pas trouve
template <class T>
Cellule<T> * ListeChainee<T>::getCellule( const char * szNom )
{
    if ( m_iSize > 0 )
    {
        Cellule<T> *pCel;
        pCel=m_pDebut;
        
        while ( pCel != NULL)
        {
            if (strcmp(pCel->m_szNom,szNom)==0)
                break;
            pCel=pCel->m_pSuivant;     
        }
        
        return pCel;        
    }
    return NULL;
}

template <class T>
Cellule<T> * ListeChainee<T>::getCellule(const int iRang)
{
    if (iRang >= m_iSize || iRang < 0)
        return NULL;
        
    if (iRang == m_iRang)
        return m_pCourant;
        
    int iDistDebut = iRang;
    int iDistFin = m_iSize - iRang - 1;//-1 car on compte  partir de 0
    int iDistCourant = m_iRang - iRang ; 
    int iRangDep; // rang de depart de parcours de la liste
    Cellule<T> *pTemp; 
    bool inc; // variable d'incrmentation ou dcrmentation
    
    // vrifie distCourrant positif
    if ( iDistCourant < 0 )
        iDistCourant = -iDistCourant;
        
    if (iDistDebut < iDistFin)
    {
        if ( iDistDebut <= iDistCourant)
        {
                iRangDep=0;
                pTemp = m_pDebut;
                inc = true;
        }    
        else
        {
                pTemp = m_pCourant;
                iRangDep=m_iRang;
                if ( m_iRang - iRang < 0) // la cellule est situ aprs le ptr courrant

                    inc = true; 
                else
                    inc = false;
        }
    }
    else
    {
        if ( iDistFin <= iDistCourant)
        {
                pTemp = m_pFin;
                iRangDep=m_iSize-1;
                inc = false;
        }
        else
        {
                pTemp = m_pCourant;
                iRangDep=m_iRang;
                if ( m_iRang - iRang < 0) // la cellule est situ aprs le ptr courrant

                    inc = true; 
                else
                    inc = false;
        }
    }
    
    if (inc)
    {
        for (int i= iRangDep ; i != iRang ; i++)
        {
                pTemp = pTemp->m_pSuivant;
        }
    }
    else
    {
        for (int i = iRangDep ; i != iRang ; i--)
        {
                pTemp = pTemp->m_pPrecedent;
        }
    }
    return pTemp;
}

template <class T>
void ListeChainee<T>::initialiser()
{
    m_pDebut=NULL;
    m_pCourant=NULL;
    m_pFin=NULL;
    m_iSize=0;
    m_iRang=0;
}

template <class T>
int ListeChainee<T>::getRang(char *szNom)
{
    debut();
    do
    {
        if ( strcmp(m_pCourant->m_szNom,szNom) == 0 )
                return m_iRang;
    } while ( suivant() );
    return -1;
}

template <class T>
void ListeChainee<T>::vider()
{
    while ( m_pFin != NULL )
    {   
        del();
    }
}

#endif


